﻿namespace Code6587EN.Ch06.ConnectToProductsList
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using System;

    /// <summary>
    /// Console Application to connect to the Products catalog list
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection that will contain the new Publishing Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Create a new catalog connection manager for the site collection
                var manager = new CatalogConnectionManager(site, true);

                // Get the catalog list
                var settings = PublishingCatalogUtility.GetPublishingCatalog(site, "http://sharepoint/authoring/Lists/Products");

                // Add the catalog list to the connection manager
                manager.AddCatalogConnection(settings);
                manager.Update();
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
